-- Hold removal notification to student Event

SET @parentcategoryId=(SELECT id FROM msg_category WHERE `code`='STUDENT');
SET @msgcategoryId=(SELECT MAX(id) FROM msg_category);
INSERT INTO `msg_category` (`id`,`parentCategory`,`code`) VALUES (@msgcategoryId+1,@parentcategoryId,'REMOVAL_HOLD_NOTIFICATION_TO_STUDENT');


SET @systemmsgeventId=(SELECT MAX(id) FROM system_msg_event);
SET @msgSubCategoryId=(SELECT id FROM msg_category WHERE `code`='REMOVAL_HOLD_NOTIFICATION_TO_STUDENT');
INSERT INTO `system_msg_event` 
(`id`, `msgConfigLevelId`, `msgSubCategoryId`, `code`, `displayCode`, `eventType`, `whetherRepetationApplicable`, `whetherInitiationRuleApplicable`, `whetherScheduledEvent`, `whetherMsgScopeApplicable`, `whetherImplicitDistributionList`, `whetherDistributionRuleApplicable`, `whetherCommonMsgTemplate`, `description`) 
VALUES (@systemmsgeventId+1, '1', @msgSubCategoryId, 'REMOVAL_HOLD_NOTIFICATION_TO_STUDENT_EVENT', 'Hold removal notification to student', 'SYSTEM', 0, 0, 0, 0, 1, 0, 0, 'Applicant Hold removed from your account');


SET @sysmsgevtdefaultconfId=(SELECT MAX(id) FROM sys_msg_evt_default_conf);
INSERT INTO `sys_msg_evt_default_conf` (`id`, `systemMsgEventId`, `msgTemplateConfigId`, `initiationRuleProviderId`, `sendingPriority`) 
VALUES (@sysmsgevtdefaultconfId+1, @systemmsgeventId+1, NULL, NULL, 'IMMEDIATE');


SET @sysmsgevtdefaultscopeId=(SELECT MAX(id) FROM sys_msg_evt_default_scope);
SET @msgScopeParamId=(SELECT id FROM `msg_scope_param` WHERE paramKey='CONTEXT_RECORD_ID');
INSERT INTO `sys_msg_evt_default_scope` (`id`, `sysMsgEvtDefaultCnfgId`, `msgScopeParamId`) VALUES (@sysmsgevtdefaultscopeId+1, @sysmsgevtdefaultconfId+1, @msgScopeParamId);


SET @sysmsgevtdefaultscopeId=(SELECT MAX(id) FROM sys_msg_evt_default_scope);
SET @msgScopeParamId=(SELECT id FROM `msg_scope_param` WHERE paramKey='EVENT_TRIGGER_DATE');
INSERT INTO `sys_msg_evt_default_scope` (`id`, `sysMsgEvtDefaultCnfgId`, `msgScopeParamId`) VALUES (@sysmsgevtdefaultscopeId+1, @sysmsgevtdefaultconfId+1, @msgScopeParamId);

SET @sysmsgevtdefaultscopeId=(SELECT MAX(id) FROM sys_msg_evt_default_scope);
SET @msgScopeParamId=(SELECT id FROM `msg_scope_param` WHERE paramKey='CONFIG_LEVEL_VALUE');
INSERT INTO `sys_msg_evt_default_scope` (`id`, `sysMsgEvtDefaultCnfgId`, `msgScopeParamId`) VALUES (@sysmsgevtdefaultscopeId+1, @sysmsgevtdefaultconfId+1, @msgScopeParamId);

SET @sysmsgevtdefaultscopeId=(SELECT MAX(id) FROM sys_msg_evt_default_scope);
SET @msgScopeParamId=(SELECT id FROM `msg_scope_param` WHERE paramKey='ACADEMY_LOCATION_IDS');
INSERT INTO `sys_msg_evt_default_scope` (`id`, `sysMsgEvtDefaultCnfgId`, `msgScopeParamId`) VALUES (@sysmsgevtdefaultscopeId+1	, @sysmsgevtdefaultconfId+1, @msgScopeParamId);

SET @sysmsgevtdefaultscopeId=(SELECT MAX(id) FROM sys_msg_evt_default_scope);
SET @msgScopeParamId=(SELECT id FROM `msg_scope_param` WHERE paramKey='EXTRA_PARAMS');
INSERT INTO `sys_msg_evt_default_scope` (`id`, `sysMsgEvtDefaultCnfgId`, `msgScopeParamId`) VALUES (@sysmsgevtdefaultscopeId+1	, @sysmsgevtdefaultconfId+1, @msgScopeParamId);


-- Template data provider for the Appointment

SET @dtproviderId=(SELECT MAX(id) FROM dtprovider);
INSERT INTO `dtprovider` (`id`, `dataProviderName`, `dataProviderType`) VALUES (@dtproviderId+1, 'REMOVAL_HOLD_NOTIFICATION_TO_STUDENT_EVENT_DL', 'SQL');

SET @dtproviderId=(SELECT MAX(id) FROM dtprovider);
INSERT INTO `dtprovider` (`id`, `dataProviderName`, `dataProviderType`) VALUES (@dtproviderId+1, 'REMOVAL_HOLD_NOTIFICATION_TO_STUDENT_EVENT_RECIPIENT', 'SQL');

-- SET @dtproviderId=(SELECT MAX(id) FROM dtprovider);
-- INSERT INTO `dtprovider` (`id`, `dataProviderName`, `dataProviderType`) VALUES (@dtproviderId+1, 'BULK_DOCUMENT_DOWNLOAD_TDP', 'CB');


-- Create Recipient Type 

SET @msgRecipientId=(SELECT MAX(id) FROM msg_recipient_type);
SET @dtproviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='REMOVAL_HOLD_NOTIFICATION_TO_STUDENT_EVENT_RECIPIENT');
INSERT INTO `msg_recipient_type` (`id`, `recipientDataProviderId`, `code`) VALUES (@msgRecipientId+1, @dtproviderId, 'REMOVAL_HOLD_NOTIFICATION_TO_STUDENT_EVENT_RECIPIENT');



SET @sysmsgevtrcptdefaultconfId=(SELECT MAX(id) FROM `sys_msg_evtrcpt_default_conf`);
SET @dtproviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='REMOVAL_HOLD_NOTIFICATION_TO_STUDENT_EVENT_DL');
SET @recipientTypeId=(SELECT id FROM `msg_recipient_type` WHERE `code`='REMOVAL_HOLD_NOTIFICATION_TO_STUDENT_EVENT_RECIPIENT');
INSERT INTO `sys_msg_evtrcpt_default_conf` (`id`, `sysMsgEvtDefaultConfId`, `distrListProviderId`, `distrRuleProviderId`, `recipientTypeId`) 
VALUES (@sysmsgevtrcptdefaultconfId+1, @sysmsgevtdefaultconfId+1, @dtproviderId, NULL, @recipientTypeId);



-- Setting the query for the Applicant distribution list

SET @sqlDtproviderId=(SELECT MAX(id) FROM `sql_dtprovider`);
SET @dtproviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='REMOVAL_HOLD_NOTIFICATION_TO_STUDENT_EVENT_DL');
INSERT INTO `sql_dtprovider` (`id`, `dataProviderId`, `sqlQuery`, `jsonString`) VALUES (@sqlDtproviderId+1,@dtproviderId,
"select 
T1.id AS USER_ID 
from student_apply_hold_category T1
where T1.id in (namedParams)",NULL);


-- Setting the query for the User Recipient

SET @sqlDtproviderId=(SELECT MAX(id) FROM `sql_dtprovider`);
SET @dtproviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='REMOVAL_HOLD_NOTIFICATION_TO_STUDENT_EVENT_RECIPIENT');
INSERT INTO `sql_dtprovider` (`id`, `dataProviderId`, `sqlQuery`, `jsonString`) VALUES (@sqlDtproviderId+1,@dtproviderId,
"select 
T1.id AS ID,
T3.firstName AS FIRST_NAME,
T3.lastName AS LAST_NAME,
T3.printName AS PRINT_NAME,
T3.mobileNumber AS MOBILE_NO,
T3.emailId AS EMAIL_ID,
T3.alternateEmailId AS ALTERNATE_EMIAL_ID,
T5.holdCatName AS HOLD_CATEGARY_NAME,
T4.subHoldCatName AS HOLD_SUB_CATEGARY_NAME,
 (CASE
        WHEN
            T4.applyholdType IS NOT NULL
                AND T4.applyholdType = 'COURSE_ENROLLMENT'
        THEN
            'Course Enrollment'
        WHEN
            T4.applyholdType IS NOT NULL
                AND T4.applyholdType = 'EXAM_ENROLLMENT'
        THEN
            'Exam Enrollment'
        WHEN
            T4.applyholdType IS NOT NULL
                AND T4.applyholdType = 'HALL_TICKET_PUBLISH'
        THEN
            'Hall Ticket Publish'
        WHEN
            T4.applyholdType IS NOT NULL
                AND T4.applyholdType = 'RESULT_PUBLISH'
        THEN
            'Result Publish'
            WHEN
            T4.applyholdType IS NOT NULL
                AND T4.applyholdType = 'PROMOTION'
        THEN
            'Promotion'
        ELSE ''
    END) AS APPLY_HOLD_TYPE

from student_apply_hold_category T1
left join students T2 on T2.userId = T1.studentId
left join persons T3 on T3.id = T2.personId
left join manage_sub_hold_category T4 on T4.id = T1.subHoldCatId
left join manage_hold_category T5 on T5.id = T1.holdCatId
where T1.id in (namedParams)",'{
    "id": 1,
    "searchResultViewColumns": [
        {
            "id": 1,
            "value": "id",
            "resultKey": "ID",
            "displayCode": "",
            "displayOrder": 0
        },		 
		 {
            "id": 2,
            "value": "firstName",
            "resultKey": "FIRST_NAME",
            "displayCode": "",
            "displayOrder": 1
        },{
            "id": 3,
            "value": "lastName",
            "resultKey": "LAST_NAME",
            "displayCode": "",
            "displayOrder": 2
        },{
            "id": 4,
            "value": "printName",
            "resultKey": "PRINT_NAME",
            "displayCode": "",
            "displayOrder": 3
        },
		 {
            "id": 5,
            "value": "holdCatName",
            "resultKey": "HOLD_CATEGARY_NAME",
            "displayCode": "",
            "displayOrder": 4
        },
		 {
            "id": 6,
            "value": "subHoldCatName",
            "resultKey": "HOLD_SUB_CATEGARY_NAME",
            "displayCode": "",
            "displayOrder": 5
        },
		 {
            "id": 7,
            "value": "applyholdType",
            "resultKey": "APPLY_HOLD_TYPE",
            "displayCode": "",
            "displayOrder": 6
        }
]}');



SET @msgtemplateId=(SELECT MAX(id) FROM msg_template);
SET @sysMsgEventId=(SELECT id FROM system_msg_event where code='REMOVAL_HOLD_NOTIFICATION_TO_STUDENT_EVENT');

SET @msgtemplateconfigId=(SELECT MAX(id) FROM msg_template_config);
SET @msgSubCategoryId=(SELECT id FROM `msg_category` WHERE `code`='REMOVAL_HOLD_NOTIFICATION_TO_STUDENT');
SET @recipientTypeId=(SELECT id FROM `msg_recipient_type` WHERE `code`='REMOVAL_HOLD_NOTIFICATION_TO_STUDENT_EVENT_RECIPIENT');
SET @msgMessageTypeId=(SELECT id FROM `msg_message_type` WHERE `code`='Notifications');


INSERT INTO `msg_template_config` (`id`, `code`, `msgSubCategoryId`, `sysMsgEventId`, `recipientTypeId`, `msgMessageTypeId`, `templateDataProviderId`, `templateConfigType`, `templateConfigName`, `whetherBulkMesaging`, `approvalRequired`, `approverId`, `whetherStaticMsg`, `status`, `availableForAdhocMsg`, `academyLocationId`, `authorName`, `authorId`) 
VALUES(@msgtemplateconfigId+1,'Hold removal notification to student Template',@msgSubCategoryId,@sysMsgEventId,@recipientTypeId,@msgMessageTypeId,@templatedtproviderId+1,NULL,'Hold removal notification to student Template',NULL,'',NULL,'','APPROVED','','1','System Admin','1');


INSERT INTO `msg_template` (`id`, `msgTemplateConfigId`, `msgDeliveryModeId`, `subjectLine`, `msgContent`) 
VALUES (@msgtemplateId+1,@msgtemplateconfigId+1,'1','Hold removed from your account','<html>
<head>
	<title></title>
</head>
<body>&nbsp;
<title></title>
<p>&nbsp;</p>
<title></title>
<table align="center" style="min-width:700px; max-width:800px; border-collapse:collapse">
	<tbody>
		<tr style="background-color:#f0f0f0; line-height:20px;">
			<td style="padding:20px 20px 20px 20px;">
            
            <p style="font-family:sans-serif, Arial, Helvetica; font-size:12px"><span style="font-size:12px;"><span style="font-family:arial,helvetica,sans-serif;">Dear <strong>$recipientData[&quot;FIRST_NAME&quot;]&nbsp;$recipientData[&quot;LAST_NAME&quot;]</strong>,&nbsp</br> A hold for <strong>$recipientData[&quot;HOLD_CATEGARY_NAME&quot;]</strong> - <strong>$recipientData[&quot;HOLD_CATEGARY_NAME&quot;]</strong> on <strong>$recipientData[&quot;APPLY_HOLD_TYPE&quot;]</strong> has been removed from your account. Please contact the relevant department for further details.</span></span></p>
		
 </td>
</tr>
		
</table>
</body>
</html>');


INSERT INTO `msg_template` (`id`, `msgTemplateConfigId`, `msgDeliveryModeId`, `subjectLine`, `msgContent`) 
VALUES(@msgtemplateId+2,@msgtemplateconfigId+1,'4','Hold removed from your account','<html>
<head>
	<title></title>
</head>
<body>&nbsp;
<title></title>
<p>&nbsp;</p>
<title></title>
<table align="center" style="min-width:700px; max-width:800px; border-collapse:collapse">
	<tbody>
		<tr style="background-color:#f0f0f0; line-height:20px;">
			<td style="padding:20px 20px 20px 20px;">
            
            <p style="font-family:sans-serif, Arial, Helvetica; font-size:12px"><span style="font-size:12px;"><span style="font-family:arial,helvetica,sans-serif;">Dear <strong>$recipientData[&quot;FIRST_NAME&quot;]&nbsp;$recipientData[&quot;LAST_NAME&quot;]</strong>,&nbsp</br> A hold for <strong>$recipientData[&quot;HOLD_CATEGARY_NAME&quot;]</strong> - <strong>$recipientData[&quot;HOLD_CATEGARY_NAME&quot;]</strong> on <strong>$recipientData[&quot;APPLY_HOLD_TYPE&quot;]</strong> has been removed from your account. Please contact the relevant department for further details.</span></span></p>
		
 </td>
</tr>
		
</table>
</body>
</html>');

INSERT INTO `msg_template` (`id`, `msgTemplateConfigId`, `msgDeliveryModeId`, `subjectLine`, `msgContent`) 
VALUES(@msgtemplateId+3,@msgtemplateconfigId+1,'2',NULL,'Dear $recipientData["FIRST_NAME"] $recipientData["LAST_NAME"], 
A hold for $recipientData["HOLD_CATEGARY_NAME"] - $recipientData["HOLD_CATEGARY_NAME"] on $recipientData["APPLY_HOLD_TYPE"] has been removed from your account. Please contact the relevant department for further details.');


set sql_safe_updates=0;
update msg_template_config set templatelanguageValue= 'English' where templatelanguageValue is null;
update msg_template_config set whetherEnabled=1 where whetherEnabled is null;
set sql_safe_updates=1;


